#delimit ;

cap prog drop t3_ar1 ;
prog def t3_ar1 ;
syntax  , [bsreps(integer 3) sourcedata(string) lhs(string) rhs(string) keyrhs(string) beta0(integer 0)] ;

use "`sourcedata'" , replace ;
tempvar resid ;
tempfile main_data ;

local beta_hypothesis = `beta0' ;
local key_rhs = "`keyrhs'" ;


/* Table 3, Model 3, row 1 */
xtset statefip year ;
xtreg `lhs' `rhs'  , pa corr(ar1) vce(conventional) noconstant ;
local b_ar1 = _b[`keyrhs'] ;
local se_ar1_def = _se[`keyrhs'] ;
local N_ar1 = e(N) ;
local K = e(rank) ;
qui tab statefip ;
local G_ar1 = r(r) ;


/* Table 3, Model 3, row 3 */
/* note that vce(robust) will do cluster robust on the i-level (statefip) cluster */
xtreg `lhs' `rhs'   , pa corr(ar1) vce(robust) noconstant ;
local se_ar1_clu = _se[`keyrhs'] ;

/* we need to adjust the degrees of freedom.  xtreg sees the RHS as "policy i.statefip i.year" and uses this for degrees of freedom, both for the
standard error adjustment, and for the T-distribution used to look up critical values and compute p-values.  We suggest
*/

/* use pairs BS for standard errors */
/* used in Table 3, Model 3, row 6 */
tempfile tomerge tobsample bsout ;
sort statefip year ;
save `tomerge' ;
keep statefip ;
gen byte one =1 ;
collapse  one , by(statefip) ;
sort statefip ;
qui save `tobsample' ;

cap erase `bsout' ;
cap postclose bsout ;
qui postfile bsout beta_bs using `bsout' , replace ;

qui forvalues bb = 1/`bsreps' { ;
		qui use `tobsample' , replace ;
		bsample ;
		collapse (sum) toexpand=one , by(statefip) ;
		sort statefip ;
		merge 1:m statefip using `tomerge' ;
		keep if _merge == 3 ;
		drop _merge ;
		expand toexpand ;
		sort state year ;
		by state year: gen id = _n ;
		egen statefip2 = group(statefip id) ;

		xtset statefip2 year ;
		xtreg `lhs' `rhs'  , pa corr(ar1) vce(conventional) noconstant ;
		local b_bs = _b[`keyrhs'] ;
		post bsout (`b_bs') ;
} ;

postclose bsout ;
use `bsout' , replace ;
summ beta_bs ;
local se_ar1_clu_bs = r(sd) ;


local dof_nmk = `N_ar1' - `K' ;
local dof_gm1 = `G_ar1' - 1 ;


local p_def_Tnk = 2 * ttail(`dof_nmk',(abs(`b_ar1' - `beta0') / `se_ar1_def')) ;
local p_clu_Tg1 = 2 * ttail(`dof_gm1',(abs(`b_ar1' - `beta0') / `se_ar1_clu')) ;
local p_bsse_Tg1 = 2 * ttail(`dof_gm1',(abs(`b_ar1' - `beta0') / `se_ar1_clu_bs')) ;



qui log on t3out  ;
di ; 
di ;
di "FGLS AR(1), `lhs', `keyrhs'" ;
di ;
di "beta,  " 				_column(20) %8.4f `b_ar1' ;
di ;
di ;
di "se default,"			_column(20) %8.4f `se_ar1_def' "," 		_column(35) %6.4f `p_def_Tnk' ;
di "se rob,"				_column(20) "-"  "," 					_column(35) "-" ;
di "se clu,"				_column(20) %8.4f `se_ar1_clu' "," 		_column(35) %6.4f `p_clu_Tg1'  ;
di "se CR2,"				_column(20) "-"  "," 					_column(35) "-"   ; 
di "se CR2 wIK,"			_column(20) "-"  "," 					_column(35) "-"  ; 
di "se pairs BS,"			_column(20) %8.4f `se_ar1_clu_bs' "," 	_column(35) %6.4f `p_bsse_Tg1'  ; 
di ;
di ;
di "percentile T pairs, ,"											_column(35) "-" ;
di "percentile T Rad2, ,"											_column(35) "-" ;
di "percentile T Webb6, ,"											_column(35) "-";
di ;
di "I-K DOF,"				_column(20) "-"  "," ;
di "CSS effctv clustrs,"	_column(20) "-"  ","  ;
di ;
di "Num obs,"				_column(20) %8.0f `N_ar1' ;
di "Num clusters,"			_column(20) %8.0f `G_ar1' ;
qui log off t3out ;


end ;

